const path = require('path');

const requireDirectory = require('require-directory');

const config = require('@yandex-int/frontend-hermione-config/overrides/storybook.config');

// Можно запустить гермиону не на статически собранных бандлах сторибука, а на сторибук-сервере
// Для этого нужно запустить гермиону с env LOCAL_PORT=4100 (по умолчанию у сторибука порт такой)
const localPort = process.env.LOCAL_PORT;

function getTestName(test) {
  const listTitles = [];

  for (let currentSuite = test; currentSuite; currentSuite = currentSuite.parent) {
    const { title } = currentSuite;

    if (!title) {
      continue;
    }

    const titles = title
      .replace(/[^\s\da-zа-яё]/gi, '') // оставляем пробельный символ, 0-9, a-z, а-я
      .split(/\s+/)
      .filter(Boolean);

    listTitles.unshift(...titles);
  }

  if (listTitles.length === 0) {
    throw new Error('Invalid test title');
  }

  return listTitles
    .map((title) => title.slice(0, 1).toUpperCase() + title.slice(1).toLowerCase())
    .join('');
}

module.exports = {
  ...config,

  prepareBrowser: browser => {
    config.prepareBrowser(browser);

    // Отключаем ворнинги, с которыми мы ничего не можем сделать
    browser.extendOptions({ deprecationWarnings: false });

    const cmds = requireDirectory(module, './commands', { exclude: /\.d\.ts/ });

    Object.entries(cmds).forEach(([name, fn]) => browser.addCommand(name, fn));
  },

  retry: 3,

  takeScreenshotOnFails: {
    testFail: true, // делать скриншот при нескриншотном падении теста (включено по умолчанию)
    assertViewFail: true // делать скриншот даже при скриншотном падении теста (выключено по умолчанию)
  },
  takeScreenshotOnFailsMode: 'fullpage', // режим снятия скриншота. Доступны значения 'viewport' (по умолчанию) и 'fullpage'

  system: {
    ...config.system,
    fileExtensions: ['.ts', '.js'],
  },

  plugins: {
    ...config.plugins,
    'hermione-storybook/plugin': {
        enabled: true,
        storybookUrl: localPort ? '/iframe.html' : '/storybook/iframe.html',
    },
    '@yandex-int/frontend-hermione-config/plugins/http-server-runner': {
      ...config.plugins['@yandex-int/frontend-hermione-config/plugins/http-server-runner'],
      enabled: !localPort,
    },
  },

  sets: {
    all: {
      files: ['src/**/*.hermione.{t,j}s'],
      browsers: ['linux-chrome', 'linux-firefox'],
    },
    touch: {
      files: ['src/**/*.hermione.{t,j}s'],
      browsers: ['chrome-grid-320'],
    },
  },
  screenshotsDir(test) {
    return path.join(path.dirname(test.file), '__screenshots__', getTestName(test), test.browserId);
  },
};
