const path = require('path');
const { pathsToModuleNameMapper } = require('ts-jest');

const { compilerOptions } = require('../../tsconfig.json');

module.exports = {
  name: 'client',
  displayName: 'client',
  rootDir: path.resolve(__dirname, '../..'),
  preset: 'ts-jest',
  testEnvironment: 'jsdom',
  testMatch: [
    '<rootDir>/src/client/**/*.(spec|test).{ts,js}?(x)',
    '<rootDir>/src/pages/**/*.(spec|test).{ts,js}?(x)',
  ],
  moduleNameMapper: {
    '\\.(jpg|jpeg|png)$': '<rootDir>/.config/jest/__mocks__/noop.js',
    '\\.css$': '<rootDir>/.config/jest/__mocks__/noop.js',
    '^react$': '<rootDir>/node_modules/react',
    ...pathsToModuleNameMapper(compilerOptions.paths, { prefix: '<rootDir>/src' }),
  },
  setupFilesAfterEnv: ['<rootDir>/.config/jest/client.setup.js'],
  globals: {
    'ts-jest': {
      tsconfig: '<rootDir>/tsconfig.test.json',
      isolatedModules: process.env.TRENDBOX_CI ? false : true,
    },
  },
  collectCoverageFrom: [
    '<rootDir>/src/client/**/*.{ts,js}?(x)',
    '<rootDir>/src/pages/**/*.{ts,js}?(x)',
    // exclude dot files
    '!<rootDir>/src/**/.*',
  ],
  coverageDirectory: '<rootDir>/coverage/client',
  reporters: [
    'default',
    [
      'jest-html-reporter',
      {
        outputPath: '__reports/report-unit-client/index.html',
        pageTitle: 'Report',
        includeFailureMsg: true,
        includeConsoleLog: true,
      },
    ],
  ],
  haste: {
    forceNodeFilesystemAPI: true,
  },
};
