const path = require('path');
const { pathsToModuleNameMapper } = require('ts-jest');

const { compilerOptions } = require('../../tsconfig.json');

module.exports = {
  name: 'server',
  displayName: 'server',
  rootDir: path.resolve(__dirname, '../..'),
  preset: 'ts-jest',
  testEnvironment: 'node',
  testMatch: ['<rootDir>/src/server/**/*.(spec|test).{ts,js}'],
  moduleNameMapper: pathsToModuleNameMapper(compilerOptions.paths, { prefix: '<rootDir>/src' }),
  collectCoverageFrom: ['<rootDir>/src/server/**/*.{ts,js}?(x)'],
  coverageDirectory: '<rootDir>/coverage/server',
  reporters: [
    'default',
    [
      'jest-html-reporter',
      {
        outputPath: '__reports/report-unit-server/index.html',
        pageTitle: 'Report',
        includeFailureMsg: true,
        includeConsoleLog: true,
      },
    ],
  ],
  haste: {
    forceNodeFilesystemAPI: true,
  },
};
