const { readFileSync } = require('fs');
const { join } = require('path');

const { ENVIRONMENT } = process.env;

const staticConfig = JSON.parse(readFileSync(join(__dirname, '../../.build-config.json'), 'utf8'));

module.exports = {
  bucket: 'yandex-id',
  version: staticConfig.version,
  useYastaticCdn: true,
  freeze: {
    path: '.next/static',
    target: staticConfig.staticPath,
    overwrite: ENVIRONMENT === 'beta',
    sources: [
      '**/*.css',
      '**/*.js',
      '**/*.svg',
      '**/*.png',
      '**/*.ico',
      '**/*.jpg',
      '**/*.jpeg',
    ],
  },
}
