module.exports = {
  plugins: ['@yandex-id/i18n'],
  rules: {
    'react/jsx-uses-react': 'off',
    'react/react-in-jsx-scope': 'off',
    'no-restricted-imports': [
      'error',
      {
        importNames: ['default', 'i18nRaw', 'setI18nLang', 'getI18nLang'],
        // eslint-disable-next-line @yandex-id/i18n/no-unwrapped-strings
        message: 'Используй @client/shared/libs/i18n',
        name: '@yandex-int/i18n',
      },
    ],
    '@yandex-id/i18n/no-unwrapped-strings': 'warn',
    '@yandex-id/i18n/no-toplevel-i18n-calls': 'error',
    'valid-jsdoc': 'off',
    'no-console': ['error', { allow: ['warn', 'error', 'debug', 'info'] }],
  },
};
