import _ from 'lodash';
import React, { FC, useMemo } from 'react';

import { MockedProvider, MockedResponse } from '@apollo/client/testing';
import { LocaleProvider, SSRProvider } from '@use-platform/react';
import { ThemeProvider } from '@yandex-id/design-system';

import { EnvProvider } from '../../../../src/client/shared/libs/env';
import { getI18nLang } from '../../../../src/client/shared/libs/i18n';
import { NextData } from '../../../../src/client/shared/next';
import { RecursivePartial } from '../../../../src/shared/types/recurse-partial';

import './global.css';

interface StoryGlobalProps {
  next?: RecursivePartial<NextData>;
  dataMock?: ReadonlyArray<MockedResponse>;
}

export const StoryContainer: FC<StoryGlobalProps> = (props) => {
  const nextData = useNextData(props.next);
  const {
    props: { serverSideProps },
  } = nextData;

  window.__NEXT_DATA__ = nextData;

  return (
    <EnvProvider value={serverSideProps}>
      <LocaleProvider locale={getI18nLang()}>
        <MockedProvider mocks={props.dataMock}>
          <SSRProvider>
            <ThemeProvider>{props.children}</ThemeProvider>
          </SSRProvider>
        </MockedProvider>
      </LocaleProvider>
    </EnvProvider>
  );
};

function useNextData(nextData?: RecursivePartial<NextData>) {
  return useMemo(() => {
    const defaultData = window.__NEXT_DATA__ as NextData;

    return _.merge(defaultData, nextData);
  }, [nextData]);
}
