import { useRef } from 'react';
import { StoryContainer } from './container';
import { reloadWindowOnNewLocale } from './locale';

export function decorator(Story, params) {
  reloadWindowOnNewLocale(params.globals, params.args);

  let { args: { graphql }, argTypes: { graphql: graphqlType } } = params;

  if (typeof graphql !== 'object') {
    graphql = graphqlType?.mapping?.[graphql]
  }

  // MockProvider не умеет обновляться при обновлении данных
  // Форсим создание нового инстанса всего контейнера через изменение key при изменении данных
  const dataRef = useRef(null);
  const updateRef = useRef(0);

  if (dataRef.current !== graphql) {
    updateRef.current++;
    dataRef.current = graphql;
  }

  return (
    <StoryContainer
      key={updateRef.current}
      next={{
        locale: params.globals.locale.id,
        props: {
          serverSideProps: {
            language: params.globals.locale,
          },
        },
      }}
      dataMock={graphql}
    >
      {Story()}
    </StoryContainer>
  );
}
