import qs from 'qs';

import { buildArgsParam, stringifyQuery } from '@storybook/router';

/**
 * Если в глобалах приехал новый язык, то нужно перезагрузить страницу,
 * чтобы подкачались нужные языки
 * Но для обновления нужно правильно обновить урл, т.к. сторибук этого не делает
 * @param globals
 */
export function reloadWindowOnNewLocale(globals: any, args: any) {
  if (!globals || !globals.locale || !window.__NEXT_DATA__ ||
    (globals.locale.id === window.__NEXT_DATA__.locale)
  ) {
    return
  }

  const currentArgs = qs.parse(location.search, { ignoreQueryPrefix: true });

  currentArgs.args = mergeParams(String(currentArgs.args), args);
  currentArgs.globals = mergeParams(String(currentArgs.globals), globals);

  // Не добавляем новое состояние истории, как у сторибука
  history.replaceState(null, '', location.pathname + stringifyQuery(currentArgs));
  location.reload();
}

function mergeParams(urlQueryParamValue: string, newParams: object) {
  let currentParams = {};

  if (typeof urlQueryParamValue === 'string') {
    currentParams = qs.parse(urlQueryParamValue.replace(/:/g, '='), { allowDots: true, delimiter: ';' });
  }

  return buildArgsParam({}, Object.assign({}, currentParams, newParams))
}

export const globalTypes = {
  locale: {
    name: 'Locale',
    description: 'Page locale',
    defaultValue: { id: 'ru', name: 'Ru' },
    toolbar: {
      icon: 'globe',
      items: [
        { value: { id: 'ru', name: 'Ru' }, right: '🇷🇺', title: 'Русский' },
        { value: { id: 'en', name: 'En' }, right: '🏴󠁧󠁢󠁥󠁮󠁧󠁿', title: 'Английкий' },
        { value: { id: 'kk', name: 'Kz' }, right: '🇰🇿', title: 'Казахский' },
        { value: { id: 'hy', name: 'AM' }, right: '🇦🇲', title: 'Армянский' },
        { value: { id: 'he', name: 'IL' }, right: '🇮🇱', title: 'Иврит' },
        { value: { id: 'tr', name: 'TR' }, right: '🇹🇷', title: 'Турецкий' },
      ],
    },
  },
};
