import React, { FC, useCallback } from 'react';

import { useGlobals } from '@storybook/api';
import { TooltipLinkList, WithTooltip } from '@storybook/components';

import { ToolbarButton } from './ToolbarButton';

export const ColorSchemaSelect: FC = () => {
  const [globals, updateGlobals] = useGlobals();
  const { colorSchema = 'light' } = globals;

  const selectSchema = useCallback((colorSchema: string) => {
    updateGlobals({ colorSchema });
  }, []);

  return (
    <WithTooltip
      placement="top"
      trigger="click"
      closeOnClick
      tooltip={({ onHide }) => {
        const links = ['light', 'dark'].map((id) => {
          return {
            id,
            title: id,
            active: colorSchema === id,
            onClick: () => {
              selectSchema(id);
              onHide();
            },
          };
        });

        return <TooltipLinkList links={links} />;
      }}
    >
      <ToolbarButton icon="contrast" description="Switch color schema">
        {colorSchema}
      </ToolbarButton>
    </WithTooltip>
  );
};
