import React, { useLayoutEffect } from 'react';

import { AnyFramework, StoryContext, PartialStoryFn as StoryFunction } from '@storybook/csf';

import { ThemeProvider } from '../../../../src/client/shared/design-system';

export function withThemeProvider(
  StoryFn: StoryFunction<AnyFramework>,
  context: StoryContext<AnyFramework>,
) {
  const { globals } = context;
  const { colorSchema } = globals;

  useLayoutEffect(() => {
    // NOTE: Возможно нужно придумать что-то на уровне самого ThemeProvider
    // Сейчас это сделано для того, чтобы указать цвет фона для body
    document.body.dataset.theme = 'default';
    document.body.dataset.color = colorSchema;
    document.body.style.backgroundColor = 'var(--id-color-surface-elevated-0)';
  }, [colorSchema]);

  return (
    <ThemeProvider theme="default" colorScheme={colorSchema}>
      {StoryFn()}
    </ThemeProvider>
  );
}
