const TsconfigPathsPlugin = require('tsconfig-paths-webpack-plugin');

module.exports = {
  stories: ['../src/client/**/*.examples.@(ts|tsx)', '../src/pages/**/*.examples.@(ts|tsx)'],
  addons: [
    '@storybook/addon-essentials',
    '@storybook/addon-postcss',
    {
      name: '@storybook/addon-postcss',
      options: {
        postcssLoaderOptions: {
          implementation: require('postcss'),
        },
      },
    },
    'hermione-storybook',
    'storybook-addon-next-router',
    './addons/toolbar/preset',
    './addons/css-modules/preset',
  ],
  typescript: {
    check: false,
    reactDocgen: false,
  },
  core: {
    builder: 'webpack5',
  },
  webpackFinal: (config) => {
    config.resolve.plugins = [new TsconfigPathsPlugin()];

    return config;
  },
};
