import { RouterContext } from 'next/dist/shared/lib/router-context';
import * as NextImage from 'next/image';

import {
  decorator as idPageDecorator,
  globalTypes as localeGlobalTypes,
} from './addons/id-page-decorator';
import { mockDateDecorator } from './addons/mock-date-decorator';

import 'yandex-font/build/browser.css';

export const parameters = {
  actions: {
    argTypesRegex: '^on[A-Z].*',
  },
  controls: {
    hideNoControlsWarning: true,
  },
  nextRouter: {
    Provider: RouterContext.Provider,
    path: '/',
    asPath: '/',
    query: {},
    push: () => {},
  },
};

export const decorators = [idPageDecorator, mockDateDecorator];

export const globalTypes = { ...localeGlobalTypes };

const OriginalNextImage = NextImage.default;

Object.defineProperty(NextImage, 'default', {
  configurable: true,
  value: (props) => <OriginalNextImage {...props} unoptimized />,
});
