const path = require('path');
const { sync: rmSync } = require('rimraf');

const { langs } = require('./common');

const dispatcher = require.resolve('./lib/dispatcher');
const parser = require.resolve('./lib/parser.js');

function initEmptyConfig() {
  const config = {};

  config.tanker || (config.tanker = {});
  config.parsers || (config.parsers = {});
  config.dispatchers || (config.dispatchers = {});
  config.resolving ||
    (config.resolving = {
      alwaysTrust: [],
      neverTrust: [],
    });

  return config;
}

function resolve(chunk) {
  return path.resolve(__dirname, chunk);
}

const [, executable, command] = process.argv;

// Определяем запуск tanker sync и удаляем map.json
// чтобы форсировать всегда обновленную информацию по переводам в коде
if (executable.endsWith('/tanker') && command === 'sync') {
  rmSync(resolve('./map.json'));
  rmSync(resolve('./ref.json'));
}

module.exports = (config) => {
  if (!config) {
    config = initEmptyConfig();
  }

  config.root = resolve('../');

  const levels = ['../src/client', '../src/pages'].map(resolve);

  config.levels = levels;
  config.levelPrefixes = ['', 'pages'];
  config.finders = ['find ' + levels.join(' ') + ' \\( -name "*.ts" -o -name "*.tsx" \\) -a ! -path "*.i18n/*"']
  config.useAllTranslations = false;
  config.removeTranslatedKeys = false;

  config.tanker.project = 'yandex-id';
  config.tanker.langs = langs;
  config.tanker.default = 'ru';
  config.tanker.branch = 'master';
  config.tanker.token = process.env.TANKER_TOKEN || process.env.TANKER_API_TOKEN;
  config.tanker.force = true;
  config.parsers.ts = parser;
  config.parsers.tsx = parser;
  config.parsers['page.tsx'] = parser;
  config.parsers['page.ts'] = parser;
  config.dispatchers.json = dispatcher;
  config.resolving.alwaysTrust.push('keyset');
  config.resolving.neverTrust = config.resolving.neverTrust.filter((item) => item !== 'keyset');

  config.bemDispatcher = {
    levelResolver: (filePath) => {
      return path.dirname(filePath);
    },
  };

  return config;
};
