// копипаста из парсера bem_serp с заменой bem.js на tanker-ts-i18n
const fs = require('fs');
const path = require('path');

const _ = require('lodash');

const { extractI18NKeysFromSourceCode } = require('./extract');
const util = require('tanker-kit/ext/lib/util');

const config = require('../config');

const isString = (a) => typeof a === 'string';

function loadI18nTsModule(filePath) {
  const content = fs.readFileSync(filePath, 'utf8');
  return JSON.parse(
    content
      .replace(/export const [a-z]{2} = {/, '{')
      .replace(/};/, '}')
    );
}

module.exports = function (arg) {
  /**
   * в arg приходит объект вида
   * {
   *     data: 'контент файла',
   *     path: 'путь к файлу отоносительно .tanker',
   *     type: 'priv.js, js и тп'
   * }
   */

  const { tanker: { langs }, useAllTranslations } = config();
  const content = arg.data;
  const filePath = arg.path;

  const keys = extractI18NKeysFromSourceCode(
    content,
    '/i18n',
    'i18n',
    filePath,
  );

  let result = [];

  // Если хотим загрузить все переводы в танкер, то кроме исходников парсим файлы с переводами и добавляем все ключи (на всех языках) в результат
  if (useAllTranslations) {
    keys
      .forEach((key) => {
        const { name } = key;

        const keysetDir = path.resolve(path.dirname(filePath), 'i18n');
        const keysetRu = loadI18nTsModule(path.resolve(keysetDir, 'ru.ts'));

        langs.forEach((lang) => {
          const newKey = _.cloneDeep(key);
          newKey.language = lang;

          const keysetFile = path.resolve(keysetDir, `${lang}.ts`);
          const keyLangValue = loadI18nTsModule(keysetFile)[name];
          const isRussianOrigin = typeof keyLangValue === 'string' && /[а-яё]/i.test(keyLangValue);

          // дорбавялем перевод в синк, если это русский, если есть перевод (отличается от русского),
          // если русский оригинал не содержит кириллицы (Yandex.Pay)
          if (keyLangValue && ((keyLangValue !== keysetRu[name]) || lang === 'ru' || !isRussianOrigin)) {
            newKey.language = lang;
            if (typeof keyLangValue === 'object') {
              newKey.value = [keyLangValue.one || name, keyLangValue.some || '', keyLangValue.many || '', keyLangValue.none || ''];
              newKey.plural = true;
            } else {
              newKey.value = keyLangValue;
            }

            result.push(newKey);
          }

        })
      });
  } else {
    // иначе используем только ключи из исходников на русском
    result = keys;
  }

    return result.map((key) => {
      const { name, fragment, range, location, keyset, params, context, language } = key;

      const keyAdapter = {
        type: 'bem',
        hash: util.getHash(key, filePath),
        path: filePath,
        fragment: fragment,
        range: range,
        location: [location.line, location.column],
        upload: true,
        single: (isString(keyset) && isString(name)) || null,
        keyset: isString(keyset) ? keyset : null,
        key: isString(name) ? name : null,
        value: key.value != undefined ? key.value : null,
        comment: '', // Никто больше не использует это поле
        context: context || '',
        language,
        plural: key.plural || null,
        params: Array.isArray(params)
          ? params.reduce(function (acc, param) {
              return Object.assign({}, acc, param);
            }, {})
          : false,
      };

      return { key: keyAdapter, _key: key };
    })
    .map(({ key, _key }) => {
      const params = key.params || {};

      // Пока эту логику просто закоментирую
      // Если ID ключа на английском:
      // - не выгружать в Танкер
      // - не считать, что ID как-то связано со значением ключа
      //
      // Если ID ключа не на английском:
      // - Сделать значение ключа равным ID
      // if (isString(key.key) && /^[\w-]+$/.test(key.key)) {
      //   key.upload = false;
      // } else {
      if (!key.value && (key.language === 'ru' || !key.language)) {
        key.value = key.key;
      }
      // }

      // Если в параметрах ключа есть поля 'some', 'many' или 'none':
      // - Считать ключ склоняемым
      // - Считать первой формой склонения значение ключа, определенное выше
      // - Вторую и третью берем из параметров some и many соответственно
      // - В русском языке "четвертая форма" всегда равна третьей
      if (typeof key.plural !== 'boolean') {
        if (params.some || params.many || params.none) {
          //  || params.count != undefined) {
          key.plural = true;
          key.value = [
            key.value,
            params.some || null,
            params.many || null,
            params.none || params.many || null,
          ];
          key.params = false;
        } else {
          key.plural = false;
        }
      } else {
        key.params = false;
      }

      if (key.context) {
        key.params = { context: key.context };
      }

      return key;
    });
};
