declare module '@yandex-int/bunker-to-js' {
  export interface BunkerToJsConfig {
    /**
     * Урл в апи бункера
     *
     * @example 'http://bunker-api.yandex.net/v1' - продовые инстансы
     * @example 'http://bunker-api-dot.yandex.net/v1' — тестовые инстансы с продовыми данными (для разработки)
     * @type {string}
     * @memberof BunkerToJsConfig
     */
    api: string;
    base?: string;
    version?: 'latest' | 'stable' | string;
    project: string;
    /**
     * Возвращать ли содержимое каталогов (не путать с дочерними узлами)
     * По умолчанию нет
     *
     * @type {boolean}
     * @default false
     * @memberof BunkerToJsConfig
     */
    directories?: boolean;
    limit?: number;
    /**
     * Использовать ли фризинг для защиты от изменения возвращаемых данных
     *
     * @default true
     * @type {boolean}
     * @memberof BunkerToJsConfig
     */
    freeze?: boolean;

    parsers: Middleware[];
  }

  export interface Node<TNodeValue = unknown> {
    /**
     * Строка с описанием mime-типа узла
     *
     * @example application/json; charset=us-ascii
     * @memberof Node
     * */
    mime: Object;

    /**
     * Относительный путь к узлу
     *
     * @type {string}
     * @memberof Node
     */
    relative?: string;

    /**
     * Полный путь к узлу
     *
     * @type {string}
     * @memberof Node
     */
    fullName: string;

    isDeleted?: boolean;

    /**
     * Содержимое узла.
     * Конкретный тип зависит от данных в бункере, включенного списка парсеров и др.
     *
     * @type {TNodeValue}
     * @memberof Node
     */
    content: TNodeValue;
  }

  export type Middleware = <TValue = unknown>(node: Node<TValue>, next: () => void) => void;

  export default class BunkerToJs<TValue> {
    public constructor(opts: BunkerToJsConfig);
    public then(resolve: (data: TValue) => void, reject?: (error: Error) => void);
    public parse<TValue = unknown>(fn: Middleware<TValue>): void;
    public use<TValue = unknown>(fn: Middleware<TValue>): void;
    public static filter: {
      hidden: Middleware;
      empty: Middleware;
    };

    public static avatar: Middleware;
    public static tjson: Middleware;
    public static json: Middleware;
    public static cat: Middleware;
  }
}
