declare module '@yandex-int/express-blackbox' {
  export interface ExpressBlackboxOptions {
    get_family_info?: 'yes';
    getphoneoperations?: 'yes';
  }

  export interface ExpressBlackboxResult extends ExpressBlackbox.Result {
    raw: ExpressBlackbox.PassportSessionidSingleResponse;

    phones?: Array<{
      id: string;
      phone: string;
      e164number: string;
      isBound?: '1';
      isDefault?: '1';
      isSecured?: '1';
    }>;
    hasPublicIdSet?: '1';
  }
}

declare namespace ExpressBlackbox {
  export interface PassportUser {
    family_info?: {
      admin_uid: string;
      family_id: string;
    };
    auth: {
      social?: any;
    };
  }

  export interface PassportSessionidSingleResponse {
    display_name: {
      public_name: string;
      name: string;
      avatar: string;
    };
    phone_operations?: Record<string, string>;
    public_id: string;
  }

  export interface Result {
    lastPasswordUpdate: string;
    havePlus?: string;
    is2faWithKey?: string;
    is2faWithSms?: string;
    isQrDisabled?: string;
    raw: PassportSessionidSingleResponse;
    firstName?: string;
    lastName?: string;
    birthdate?: string;
    isChild?: string;
    city?: string;
    question?: string;
    gender?: string;
    timezone?: string;
    hasFamilyPlus?: string;
  }
}
