#!/usr/bin/env bash
export NEXT_TELEMETRY_DISABLED=1
export NO_COLOR=1
export NODE_EXTRA_CA_CERTS=/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt
export NODE_DNS_GRACEFUL_STACK_SWITCH_DEFAULT=4
export NODE_ENV=production
export TVMTOOL_LOCAL_AUTHTOKEN=`cat /etc/yandex/id-frontend/tvmtool.local.auth`
export STATIC_MAPS_SIGNING_SECRET=`cat /etc/yandex/id-frontend/map-signing-secret.env`
export STATIC_MAPS_API_KEY=`cat /etc/yandex/id-frontend/map-api-key.env`
export DEPLOY_TVM_TOOL_URL=http://localhost:3010
export PASSPORT_API_URL=http://127.0.0.1
export NODE_ICU_DATA=/usr/lib/yandex/id-frontend/node_modules/full-icu
export NODE_OPTIONS='--max-http-header-size 131072'
export PORT=3012
export USE_SESSGUARD=1
export WORKERS=1
export FORK_TIMEOUT=30000
export WORKER_PING_INTERVAL=30000
export WORKER_TIMEOUT=28000

YENV=`cat /etc/yandex/environment.type`
case $YENV in
  stress)
    export YENV=stress;;
  testing | unstable)
    export YENV=testing;;
  rc)
    export YENV=rc;;
  production)
    export YENV=production;;
  *)
    export YENV=production;;
esac

NODE_BIN=/usr/lib/yandex/id-frontend/node/bin
LOG_SOCKET=/var/run/id-front.pipe

while read line; do echo "$line" >> /var/log/yandex/id-frontend/service.log; done < ${LOG_SOCKET} &

$NODE_BIN/node $NODE_BIN/npm run start:prod >${LOG_SOCKET} 2>&1
