#!/usr/bin/env bash
export QLOUD_TVM_TOKEN=`cat /etc/yandex/id-frontend/tvmtool.local.auth`
export LOGFILE=/var/log/yandex/id-frontend/tvmtool.log

function logger {
    while read line; do echo "$line" >> ${LOGFILE}; done;
}

(/usr/sbin/tvmtool -c /etc/yandex/id-frontend/tvmtool.conf --port 3010 --cache-dir /var/cache/tvmtool-id-frontend/ 2>&1 | logger) &

sleep 1
TOOL_PID=$(pgrep -f '/usr/sbin/tvmtool -c /etc/yandex/id-frontend/tvmtool.conf')
echo TOOL_PID: $TOOL_PID >>$LOGFILE

# на попытку завершения процесса проверяем завершился ли tmvtool и освободился ли порт
# trap '(echo "Waiting for $TOOL_PID"; kill $TOOL_PID; wait $TOOL_PID; echo Done ; while lsof -nP -itcp:3010 -stcp:LISTEN; do date; sleep 1; done)>>$LOGFILE' EXIT;
trap '(echo "Waiting for $TOOL_PID"; timeout 3 tail --pid=$TOOL_PID -f /dev/null && echo Done || (kill -9 $TOOL_PID; echo "Killed"))>>$LOGFILE' EXIT;

WATCHDOG=3;
(while [ $WATCHDOG -gt 0 ] ; do
        [ "$(curl http://127.0.0.1:3010/tvm/ping -sm 0.5)" == "OK" ] && WATCHDOG=3 || let WATCHDOG--;
        sleep 1;
        [ $WATCHDOG -lt 3 ] && echo $(date): WATCHDOG=${WATCHDOG};
done) 2>&1 | logger;

if [ $WATCHDOG -le 0 ];
    kill -TERM $TOOL_PID;
    exit 1;
fi
