/* eslint-disable @typescript-eslint/no-var-requires */
/* eslint-disable camelcase */
const path = require('path');

const nextConstants = require('next/constants');
const { readFileSync } = require('fs');
const { join } = require('path');

function getAssetPrefixUrl() {
  const { YENV, USE_LOCAL_ASSET } = process.env;

  if (USE_LOCAL_ASSET === '1') {
    return;
  }

  const yastaticHost = 'https://yastatic.net';
  const yastaticPath = 's3/yandex-id-static';

  switch (YENV) {
    case 'local':
    case 'development':
      return;
    case 'testing':
    case 'rc':
    case 'production':
      try {
        const staticPath = JSON.parse(
          readFileSync(join(__dirname, '.build-config.json'), 'utf-8'),
          // Удаляем /_next/static из пути, т.к. next сам подставит этот путь.
        ).staticPath.replace('/_next/static', '');

        return new URL(join(yastaticPath, staticPath), yastaticHost).href;
      } catch (_) {
        return;
      }
    default:
      return;
  }
}

module.exports = (phase, { defaultConfig = {} }) => {
  const baseConfig = {
    ...defaultConfig,
    reactStrictMode: false,
    poweredByHeader: false,
    assetPrefix: getAssetPrefixUrl(),
    pageExtensions: ['page.tsx', 'page.ts', 'page.jsx', 'page.js'],
  };

  if (phase === nextConstants.PHASE_PRODUCTION_SERVER) {
    return baseConfig;
  }

  return {
    ...baseConfig,
    webpack: (config, options) => {
      require('next-global-css').patchWebpackConfig(config, options);
      require('./tools/i18n-chunk-plugin').i18nPatchWebpackConfig(config, options);
      require('./tools/rum-eb-bundler/index.js').rumEBBundlerConfig(config, options);

      if (options.isServer) {
        // Указываем модули, которые должны будут попасть в серверный бандл
        // для того, чтобы иметь возможность обрабатывать css-modules.
        config.externals = require('webpack-node-externals')({
          allowlist: [
            /@yandex-id\/components/,
            /@yandex-id\/search-suggest/,
            /@yandex-int\/tap-components/,
            /@yandex-int\/rum-counter/,
            /@yandex-int\/error-counter/,
            /@yandex-lego\/components/,
            /design-system/,
          ],
        });
      }

      config.resolve.alias.react$ = path.resolve(__dirname, 'node_modules/react');
      config.resolve.alias['react-dom$'] = path.resolve(__dirname, 'node_modules/react-dom');

      return config;
    },
  };
};
