import { VFC } from 'react';

import { AuthType } from '@client/shared/api/graphql';
import crossFilledSrc from '@client/shared/assets/cross-filled.png';
import { RouterLink } from '@client/shared/libs/router-link';
import { useIdPaths } from '@client/shared/paths';
import { Hint, ImageIcon } from '@client/shared/ui-kit';

import { i18n } from './i18n';

interface ForbiddenExternalAuthHintProps {
  authType: AuthType.PasswordAndSms | AuthType.SmsOnly | AuthType.YandexKey;
}

export const ForbiddenExternalAuthHint: VFC<ForbiddenExternalAuthHintProps> = (props) => {
  const { authType } = props;
  const isYandexKey = authType === AuthType.YandexKey;
  const idPaths = useIdPaths();

  return (
    <Hint
      as={RouterLink}
      href={idPaths.securityEnterMethods}
      text={
        isYandexKey
          ? i18n('При входе с Ключом нельзя войти внешними аккаунтами')
          : i18n('При входе с помощью смс нельзя войти внешними аккаунтами')
      }
      variant="negative"
      before={<ImageIcon src={crossFilledSrc} size={32} />}
    />
  );
};
