import { VFC } from 'react';

import shieldBrokenSrc from '@client/shared/assets/shield-broken.png';
import { RouterLink } from '@client/shared/libs/router-link';
import { useIdPaths } from '@client/shared/paths';
import { Hint, ImageIcon } from '@client/shared/ui-kit';

import { i18n } from './i18n';

interface InsecureAuthHintProps {
  type: 'external-email' | 'external-social';
}

export const InsecureAuthHint: VFC<InsecureAuthHintProps> = (props) => {
  const { type } = props;
  const isExternalSocial = type === 'external-social';
  const idPaths = useIdPaths();

  return (
    <Hint
      as={RouterLink}
      href={idPaths.securityEnterMethods}
      variant="negative"
      text={
        isExternalSocial
          ? i18n('Вы входите внешним аккаунтом. Переключитесь на надёжный способ входа')
          : i18n('Вы входите внешней почтой. Переключитесь на надёжный способ входа')
      }
      before={<ImageIcon src={shieldBrokenSrc} size={32} />}
    />
  );
};
