export enum SmsCodeConfirmationEventType {
  CHANGE_CODE = 'CHANGE_CODE',
  RESEND_CODE = 'RESEND_CODE',
  VERIFY_CODE = 'VERIFY_CODE',
}

export interface SmsCodeConfirmationChangeEvent {
  type: SmsCodeConfirmationEventType.CHANGE_CODE;
  code: string;
}

export interface SmsCodeConfirmationSubmitEvent {
  type: SmsCodeConfirmationEventType.VERIFY_CODE;
  code: string;
}

export interface SmsCodeConfirmationResendEvent {
  type: SmsCodeConfirmationEventType.RESEND_CODE;
}

export type SmsCodeConfirmationEvent =
  | SmsCodeConfirmationChangeEvent
  | SmsCodeConfirmationSubmitEvent
  | SmsCodeConfirmationResendEvent;
