/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent, useStore } from 'effector-react';

import { useDevice } from '@client/shared/hooks';
import { Button, CardTemplate, Dialog, Text } from '@client/shared/ui-kit';

import { factory } from './model';

import styles from './CloseConfirmationDialog.module.css';

export const CloseConfirmationDialog = factory.view(() => {
  const { isTouch } = useDevice();
  const model = factory.useModel();

  const onConfirm = useEvent(model.confirmed);
  const onDecline = useEvent(model.declined);

  const isVisible = useStore(model.dialog.$isVisible);

  return (
    <Dialog visible={isVisible} onClose={onDecline} keepMounted={false}>
      <CardTemplate className={styles.content}>
        {!isTouch && (
          <CardTemplate.Content>
            <Text variant="heading-l" weight="bold">
              Точно закрыть?
            </Text>
          </CardTemplate.Content>
        )}

        <CardTemplate.Actions>
          <Button variant="default" size="xl" onPress={onConfirm}>
            Закрыть форму
          </Button>
          <Button variant="clear" size="xl" onPress={onDecline}>
            Продолжить редактирование
          </Button>
        </CardTemplate.Actions>
      </CardTemplate>
    </Dialog>
  );
});
