/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent, useStore } from 'effector-react';

import { Button, CardTemplate, Dialog, ImageIcon, Text } from '@client/shared/ui-kit';

import { factory } from './model';

import styles from './DeleteConfirmationDialog.module.css';

interface DeleteConfirmationDialogProps {
  cover: StaticImageData | string;
  text: string;
}

export const DeleteConfirmationDialog = factory.view<DeleteConfirmationDialogProps>((props) => {
  const { cover, text } = props;

  const model = factory.useModel();

  const onConfirm = useEvent(model.confirmed);
  const onDecline = useEvent(model.declined);

  const isVisible = useStore(model.dialog.$isVisible);

  return (
    <Dialog visible={isVisible} onClose={onDecline} keepMounted={false} className={styles.modal}>
      <div className={styles.content}>
        <CardTemplate>
          <CardTemplate.Media>
            <ImageIcon src={cover} size={120} />
          </CardTemplate.Media>

          <CardTemplate.Content align="center">
            <Text variant="heading-l" weight="bold">
              {text}
            </Text>
          </CardTemplate.Content>

          <CardTemplate.Actions>
            <Button size="xl" variant="default" onPress={onConfirm}>
              Удалить
            </Button>

            <Button size="xl" variant="clear" onPress={onDecline}>
              Оставить всё как есть
            </Button>
          </CardTemplate.Actions>
        </CardTemplate>
      </div>
    </Dialog>
  );
});
