import { createEvent, sample } from 'effector';

import { createDialogApi } from '@client/shared/libs/effector-helpers/dialog';
import { createModelApi } from '@client/shared/libs/effector-helpers/view-model-factory';

export const factory = createModelApi(() => {
  const dialog = createDialogApi();

  const confirmed = createEvent();
  const declined = createEvent();

  sample({
    clock: [confirmed, declined],
    target: dialog.hide,
  });

  return {
    dialog,
    confirm: dialog.show,
    confirmed,
    declined,
  };
});
