import { VFC } from 'react';

import { useEnvContext } from '@client/shared/libs/env';
import { Button, Dialog, Text } from '@client/shared/ui-kit';

import styles from './CloseFormDialog.module.css';

export interface CloseFormDialogProps {
  isVisible: boolean;
  onContinueEditing: () => void;
  onCloseForm: () => void;
  onCloseDialog: () => void;
}

export const CloseFormDialog: VFC<CloseFormDialogProps> = ({
  isVisible,
  onContinueEditing,
  onCloseForm,
  onCloseDialog,
}) => {
  const {
    ua: { isTouch },
  } = useEnvContext();

  return (
    <Dialog className={styles.root} visible={isVisible} onClose={onCloseDialog} hasClose>
      {!isTouch && (
        <Text className={styles.heading} as="h3" variant="heading-l" weight="bold">
          Точно закрыть?
        </Text>
      )}
      <div className={styles.actions}>
        <Button className={styles.button} size="xl" onPress={onCloseForm}>
          Закрыть форму
        </Button>
        <Button className={styles.button} variant="clear" size="xl" onPress={onContinueEditing}>
          Продолжить редактирование
        </Button>
      </div>
    </Dialog>
  );
};
