import { VFC } from 'react';

import { Skeleton } from '@client/shared/ui-kit';

interface MultiFieldSkeletonProps {
  count: number;
}

const FIELD_Y_START = 5 + 25;
const FIELD_HEIGHT = 48;
const GAP = 8;

export const MultiFieldSkeleton: VFC<MultiFieldSkeletonProps> = (props) => {
  const { count } = props;

  // margin-top + label + высота всех филдов + расстояние между филдами
  const height = FIELD_Y_START + count * FIELD_HEIGHT + (count - 1) * GAP;

  return (
    <Skeleton width="100%" height={height}>
      <rect y="5" rx="6" ry="6" width="124" height="12" />
      {Array(count)
        .fill(0)
        .map((_, i) => (
          <rect
            key={i}
            y={FIELD_Y_START + FIELD_HEIGHT * i + GAP * i}
            rx="14"
            ry="14"
            width="100%"
            height="48"
          />
        ))}
    </Skeleton>
  );
};
