import { VFC } from 'react';

import { Skeleton } from '@client/shared/ui-kit';

interface DocumentImageListSkeletonProps {
  size: 's' | 'm';
}

const GAP = 6;

export const DocumentImageListSkeleton: VFC<DocumentImageListSkeletonProps> = (props) => {
  const { size } = props;

  const skeletonWidth = size === 's' ? 56 * 3 + GAP * 2 : 72 * 3 + GAP * 2;
  const length = size === 's' ? 56 : 72;

  return (
    <Skeleton width={skeletonWidth} height={length}>
      <rect x="0" rx="16" ry="16" width={length} height={length} />
      <rect x={length + GAP} rx="16" ry="16" width={length} height={length} />
      <rect x={2 * (length + GAP)} rx="16" ry="16" width={length} height={length} />
    </Skeleton>
  );
};
