import { ChangeEvent, VFC, useCallback, useRef } from 'react';

import { Camera, Plus } from '@client/shared/icons';
import { Button } from '@yandex-id/components/next/Button';

import { Target } from '../../types';

import styles from './AddButton.module.css';

export interface AddButtonProps {
  single?: boolean;
  onUpload: (images: FileList | null) => void;
  target: Target;
}

export const AddButton: VFC<AddButtonProps> = (props) => {
  const { target, onUpload, single = false } = props;
  const inputRef = useRef<HTMLInputElement>(null);

  const handleOnChange = useCallback(
    (event: ChangeEvent<HTMLInputElement>) => {
      onUpload(event.target.files);
    },
    [onUpload],
  );

  return (
    <>
      <input
        ref={inputRef}
        accept="image/jpeg, image/jpg, image/png, image/heic"
        id="document-uploader"
        type="file"
        style={{ display: 'none' }}
        onClick={(event) => {
          // хак, на onChange не дает загрузить одну и ту же фотку подряд
          // programmersought.com/article/52841217331/
          (event.target as HTMLInputElement).value = '';
        }}
        onChange={handleOnChange}
        multiple
      />
      {single && (
        <Button
          size="xl"
          variant="default"
          before={<Camera />}
          onPress={() => inputRef.current?.click()}
        >
          Добавить фото
        </Button>
      )}
      {!single && (
        <Button
          className={styles.button}
          variant="clear"
          data-target={target}
          as="span"
          onPress={() => inputRef.current?.click()}
        >
          <Plus />
        </Button>
      )}
    </>
  );
};
