import { VFC } from 'react';

import ghostPhotoSource from '@client/shared/assets/ghost-photo.png';
import { Button, CardTemplate, Dialog, ImageIcon, Text } from '@client/shared/ui-kit';

import styles from './DeleteImageDialog.module.css';

export interface DeleteImageDialogProps {
  isVisible: boolean;
  disabled: boolean;
  onAbort: () => void;
  onConfirm: () => void;
}

export const DeleteImageDialog: VFC<DeleteImageDialogProps> = (props) => {
  const { isVisible, disabled, onAbort, onConfirm } = props;

  return (
    <Dialog visible={isVisible} onClose={onAbort} keepMounted={false}>
      <CardTemplate className={styles.container}>
        <CardTemplate.Media>
          <ImageIcon src={ghostPhotoSource} size={120} />
        </CardTemplate.Media>

        <CardTemplate.Content align="center">
          <Text variant="heading-l" weight="bold">
            Точно удалить фотографию?
          </Text>
        </CardTemplate.Content>

        <CardTemplate.Actions>
          <Button disabled={disabled} size="xl" onPress={onConfirm}>
            Удалить
          </Button>
          <Button disabled={disabled} size="xl" variant="clear" onPress={onAbort}>
            Оставить все как есть
          </Button>
        </CardTemplate.Actions>
      </CardTemplate>
    </Dialog>
  );
};
