import { VFC } from 'react';

import { PressProps, mergeProps, useHover, usePress } from '@use-platform/react';

import styles from './Image.module.css';

interface ImageProps extends PressProps {
  src: string;
  size?: 's' | 'm';
}

export const Image: VFC<ImageProps> = (props) => {
  const { src, size = 's', ...otherProps } = props;
  const { isHovered, hoverProps } = useHover(otherProps);
  const { pressProps } = usePress(otherProps);

  return (
    <div
      data-hovered={isHovered}
      tabIndex={0}
      className={styles.root}
      {...mergeProps(hoverProps, pressProps)}
    >
      <img data-size={size} className={styles.image} src={src} />
    </div>
  );
};
