import { ReactNode, VFC } from 'react';

import { Skeleton } from '@client/shared/ui-kit';

import { DocumentImageListSkeleton } from '../document-image-list';
import { DocumentViewer } from './DocumentViewer';
import { Color } from './types';

import styles from './DocumentViewerSkeleton.module.css';

export interface DocumentViewerSkeletonProps {
  color: Color;
  icon: ReactNode;
  onClose: () => void;
}

export const DocumentViewerSkeleton: VFC<DocumentViewerSkeletonProps> = (props) => {
  const { color, icon, onClose } = props;

  return (
    <DocumentViewer isVisible onClose={onClose} color={color}>
      <DocumentViewer.Icon color={color}>{icon}</DocumentViewer.Icon>
      <DocumentViewer.Title>
        <Skeleton width={240} height={22} className={styles.title}>
          <rect rx="14" ry="14" width="240" height="22" />
        </Skeleton>
      </DocumentViewer.Title>
      <DocumentViewer.Subtitle>
        <Skeleton width={134} height={12} className={styles.subtitle}>
          <rect rx="6" ry="6" width="134" height="12" />
        </Skeleton>
      </DocumentViewer.Subtitle>
      <DocumentViewer.Preview>
        <DocumentImageListSkeleton size="m" />
      </DocumentViewer.Preview>
      <DocumentViewer.Section>
        <DocumentViewer.FieldItemSkeleton />
        <DocumentViewer.FieldItemSkeleton />
        <DocumentViewer.FieldItemSkeleton />
        <DocumentViewer.FieldItemSkeleton />
      </DocumentViewer.Section>
      <DocumentViewer.Section>
        <DocumentViewer.FieldItemSkeleton />
        <DocumentViewer.FieldItemSkeleton />
        <DocumentViewer.FieldItemSkeleton />
      </DocumentViewer.Section>
      <DocumentViewer.Section>
        <DocumentViewer.FieldItemSkeleton />
      </DocumentViewer.Section>
      <DocumentViewer.DeleteAction />
      <DocumentViewer.EditAction />
    </DocumentViewer>
  );
};
