import { VFC } from 'react';

import ghostDocumentSource from '@client/shared/assets/ghost-document.png';
import { Button, CardTemplate, Dialog, ImageIcon, Text } from '@client/shared/ui-kit';

import styles from './DeleteDocumentDialog.module.css';

export interface DeleteDocumentDialogProps {
  isVisible: boolean;
  disabled: boolean;
  name: string;
  onAbort: () => void;
  onConfirm: () => void;
}

export const DeleteDocumentDialog: VFC<DeleteDocumentDialogProps> = (props) => {
  const { isVisible, disabled, name, onAbort, onConfirm } = props;

  return (
    <Dialog visible={isVisible} onClose={onAbort} keepMounted={false}>
      <CardTemplate className={styles.container}>
        <CardTemplate.Media>
          <ImageIcon src={ghostDocumentSource} size={120} />
        </CardTemplate.Media>

        <CardTemplate.Content align="center">
          <Text variant="heading-l" weight="bold">
            Точно удалить {name}?
          </Text>
        </CardTemplate.Content>

        <CardTemplate.Actions>
          <Button disabled={disabled} size="xl" onPress={onConfirm}>
            Удалить
          </Button>
          <Button disabled={disabled} size="xl" variant="clear" onPress={onAbort}>
            Оставить все как есть
          </Button>
        </CardTemplate.Actions>
      </CardTemplate>
    </Dialog>
  );
};
