import cx from 'classnames';
import { VFC, useCallback } from 'react';

import { Copy } from '@client/shared/icons';
import { Text } from '@client/shared/ui-kit';
import { mergeProps, useHover, usePress } from '@use-platform/react';
import { ListItemView } from '@yandex-id/components';

import { notifications } from '../../notifier';

import styles from './FieldItem.module.css';

export interface FieldItemProps {
  text: string;
  label: string;
}

export const FieldItem: VFC<FieldItemProps> = (props) => {
  const { text, label } = props;

  const onPressCopy = useCallback(() => {
    navigator.clipboard.writeText(text);

    notifications.copied();
  }, [text]);

  const { hoverProps, isHovered } = useHover({});
  const { pressProps, isPressed } = usePress({
    onPress: onPressCopy,
  });

  return (
    <ListItemView
      className={cx(styles.root, {
        [styles.root_isHovered]: isHovered,
        [styles.root_isPressed]: isPressed,
      })}
      interactive={false}
      {...mergeProps(hoverProps, pressProps)}
    >
      <ListItemView.Content className={styles.content}>
        <Text variant="text-xs" color="secondary">
          {label}
        </Text>
        <Text variant="text-m-long" className={styles.text}>
          {text}
        </Text>
      </ListItemView.Content>
      <ListItemView.After className={styles.icon}>
        <Copy />
      </ListItemView.After>
    </ListItemView>
  );
};
