import { VFC } from 'react';

import { Skeleton } from '@client/shared/ui-kit';
import { ListItemView } from '@yandex-id/components';

import styles from './FieldItemSkeleton.module.css';

export const FieldItemSkeleton: VFC = () => {
  return (
    <ListItemView className={styles.root} interactive={false}>
      <ListItemView.Content className={styles.content}>
        <Skeleton width={103} height={12}>
          <rect height="100%" width="100%" rx={6} ry={6} />
        </Skeleton>
        <Skeleton width={179} height={12}>
          <rect height="100%" width="100%" rx={6} ry={6} />
        </Skeleton>
      </ListItemView.Content>
    </ListItemView>
  );
};
