import React, { FC } from 'react';

import { Description, ImageOutline } from '@client/shared/icons';
import { Dialog, Hint } from '@client/shared/ui-kit';

import { ShareItem } from '../ShareItem';

import styles from './ShareDialog.module.css';

export interface ShareDialogProps {
  isVisible: boolean;
  onAbort: () => void;
  onShareText: () => void;
  onShareImages: () => void;
  imagesQuantity: number;
}

export const ShareDialog: FC<ShareDialogProps> = (props) => {
  const { isVisible, onAbort, onShareText, imagesQuantity, onShareImages } = props;

  return (
    <Dialog visible={isVisible} keepMounted={false} onClose={onAbort}>
      <div className={styles.root}>
        <ShareItem
          icon={<Description />}
          title="Поделиться текстом"
          description="Безопаснее"
          descriptionColor="positive"
          onPress={onShareText}
        />
        <ShareItem
          icon={<ImageOutline />}
          title="Поделиться фото"
          description={`${imagesQuantity} фото`}
          onPress={onShareImages}
        />
        <Hint text="Фотографии проще использовать в мошеннических схемах" variant="negative" />
      </div>
    </Dialog>
  );
};
