import { FC, ReactNode } from 'react';

import { PressProps } from '@use-platform/react';
import { ListItemView, Text } from '@yandex-id/components';

import styles from './ShareItem.module.css';

export interface ShareItemProps extends PressProps {
  icon: ReactNode;
  title: string;
  description: string;
  descriptionColor?: 'secondary' | 'positive';
}

export const ShareItem: FC<ShareItemProps> = (props) => {
  const { description, descriptionColor = 'secondary', icon, title, ...restProps } = props;

  return (
    <ListItemView {...restProps} className={styles.root}>
      <ListItemView.Before>
        <div className={styles.plate}>{icon}</div>
      </ListItemView.Before>
      <ListItemView.Content alignItems="center">
        <Text variant="text-m">{title}</Text>
        <Text variant="text-s" color={descriptionColor} className={styles.description}>
          {description}
        </Text>
      </ListItemView.Content>
    </ListItemView>
  );
};
