import { forwardRef } from 'react';

import { ExternalAccountProviderName } from '@client/shared/api/graphql';
import { Social, SocialName, SocialProps } from '@client/shared/icons/socials';

const NAME_MAP: Record<ExternalAccountProviderName, SocialName> = {
  [ExternalAccountProviderName.Vk]: 'vk',
  [ExternalAccountProviderName.Facebook]: 'facebook',
  [ExternalAccountProviderName.Twitter]: 'twitter',
  [ExternalAccountProviderName.Mailru]: 'mail',
  [ExternalAccountProviderName.Google]: 'google',
  [ExternalAccountProviderName.Odnoklassniki]: 'ok',
  [ExternalAccountProviderName.Apple]: 'apple',
  [ExternalAccountProviderName.Esia]: 'esia',
};

export type ExternalProviderIconProps = Omit<SocialProps, 'name'> & {
  name: ExternalAccountProviderName;
};

export const ExternalProviderIcon = forwardRef<SVGSVGElement, ExternalProviderIconProps>(
  (props, ref) => {
    const { name, ...otherProps } = props;

    return <Social ref={ref} name={NAME_MAP[name]} {...otherProps} />;
  },
);
