import Axios from 'axios';

import { createSingleEffect } from '@client/shared/libs/effector-helpers';

import type { GeoLocation, GeoSuggestApiResponse } from './types';

export * from './types';

export const searchFx = createSingleEffect<string, GeoLocation[]>(async (text, signal) => {
  try {
    const response = await Axios.get<GeoSuggestApiResponse>(
      'https://suggest-maps.yandex.ru/suggest-geo',
      {
        signal,
        params: {
          callback: '',
          search_type: 'addr',
          part: text,
          v: 7,
          results: 5,
          fullpath: 1,
        },
      },
    );

    return response.data.results;
  } catch (error) {
    if (!signal.aborted) {
      return Promise.reject();
    }

    return [];
  }
});
