import { attach, createEvent, createStore, sample } from 'effector';
import { throttle } from 'patronum/throttle';

import * as api from '../api';
import { notifications } from './notifier';

export const valueChanged = createEvent<string>();
export const reset = createEvent();

export const $value = createStore('');
export const $addresses = createStore<api.GeoLocation[]>([]);

const searchFx = attach({ effect: api.searchFx });

$value.on(valueChanged, (_, value) => value);
$value.reset(reset);

$addresses.on(searchFx.doneData, (_, addresses) => addresses);
$addresses.reset(reset);

sample({
  clock: throttle({
    source: valueChanged,
    timeout: 100,
  }),
  target: searchFx,
});

sample({
  clock: searchFx.fail,
  target: notifications.internalError,
});
