import { ForwardedRef, forwardRef } from 'react';
import { useRef } from 'react';

import { List } from '@client/shared/ui-kit';
import { useListBox } from '@react-aria/listbox';
import type { ListState } from '@react-stately/list';
import { useForwardedRef } from '@use-platform/react';

import type { Option } from '../GeoSuggestOption/GeoSuggestOption';
import { ListOption } from '../ListOption/ListOption';

import styles from './ListBox.module.css';

interface ListBoxProps {
  state: ListState<unknown>;
}

function _ListBox(props: ListBoxProps, forwardedRef: ForwardedRef<HTMLDivElement>) {
  const { state, ...otherProps } = props;

  const ref = useRef<HTMLDivElement>(null);
  const { listBoxProps } = useListBox(otherProps, state, ref);

  useForwardedRef(ref, forwardedRef);

  return (
    <List {...listBoxProps} className={styles.root} ref={ref}>
      {[...state.collection].map((option) => (
        <ListOption key={option.key} option={option as Option} state={state} />
      ))}
    </List>
  );
}

export const ListBox = forwardRef(_ListBox);
