import cx from 'classnames';
import { HTMLAttributes, VFC, useRef } from 'react';

import { LocationOutline } from '@client/shared/icons';
import { ListItemView, Text } from '@client/shared/ui-kit';
import { useOption } from '@react-aria/listbox';
import type { ListState } from '@react-stately/list';

import type { Option } from '../GeoSuggestOption/GeoSuggestOption';

import styles from './ListOption.module.css';

interface ListOptionProps {
  option: Option;
  state: ListState<unknown>;
}

export const ListOption: VFC<ListOptionProps> = (props) => {
  const { state, option } = props;
  const { text, description } = option.props;
  const ref = useRef<HTMLDivElement>(null);
  const { optionProps, isFocused } = useOption(option, state, ref);

  return (
    <ListItemView
      {...(optionProps as HTMLAttributes<HTMLDivElement>)}
      className={cx(styles.root, {
        [styles.root_isFocused]: isFocused,
      })}
    >
      <ListItemView.Before>
        <LocationOutline size={24} />
      </ListItemView.Before>
      <ListItemView.Content className={styles.content}>
        <Text variant="text-m" color="primary">
          {text}
        </Text>
        <Text variant="text-s" color="secondary">
          {description}
        </Text>
      </ListItemView.Content>
    </ListItemView>
  );
};
