import cx from 'classnames';
import { ForwardedRef, ReactNode, RefObject, forwardRef, useRef } from 'react';

import { useOverlayPosition } from '@react-aria/overlays';
import { useForwardedRef } from '@use-platform/react';

import styles from './Popover.module.css';

interface PopoverProps {
  children: ReactNode;
  isVisible: boolean;
  targetRef: RefObject<HTMLElement>;
}

function _Popover(props: PopoverProps, forwardedRef: ForwardedRef<HTMLDivElement>) {
  const { isVisible, targetRef, children } = props;

  const rootRef = useRef(null);

  const { overlayProps } = useOverlayPosition({
    targetRef,
    overlayRef: rootRef,
    offset: 6,
    containerPadding: 0,
    placement: 'bottom start',
    isOpen: isVisible,
  });

  useForwardedRef(rootRef, forwardedRef);

  return (
    <div
      {...overlayProps}
      className={cx(styles.root, {
        [styles.root_isVisible]: isVisible,
      })}
      ref={rootRef}
    >
      {children}
    </div>
  );
}

export const Popover = forwardRef(_Popover);
