/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { ForwardedRef, RefObject, forwardRef } from 'react';

import { Close } from '@client/shared/icons';
import { TextButton, TextField } from '@client/shared/ui-kit';
import { useClearButton, useUniqId } from '@use-platform/react';

import styles from './SearchField.module.css';

interface SearchFieldProps {
  autoFocus?: boolean;
  error?: string;
  inputRef: RefObject<HTMLInputElement>;
  isFocused: boolean;
  value: string;
}

function _SearchField(props: SearchFieldProps, forwardedRef: ForwardedRef<HTMLElement>) {
  const { inputRef, isFocused, ...restProps } = props;

  const uid = useUniqId();
  const { buttonProps } = useClearButton(props, inputRef);
  const isNotEmpty = props.value !== '';
  const shouldShowClear = isNotEmpty && isFocused;

  return (
    <TextField
      {...restProps}
      autoComplete={uid}
      className={styles.root}
      innerRef={forwardedRef}
      inputRef={inputRef}
      placeholder="Введите адрес"
      size="xl"
      after={
        shouldShowClear && (
          <TextButton tabIndex={-1} className={styles.button} {...buttonProps}>
            <Close size={24} />
          </TextButton>
        )
      }
    />
  );
}

export const SearchField = forwardRef(_SearchField);
