import { useEvent } from 'effector-react';
import { VFC } from 'react';

import { ConfirmByPasswordModal } from '@client/features/confirm-by-password';
import { Kvko } from '@client/shared/icons';
import { logProps } from '@client/shared/libs/metrika';
import { ListItemAction } from '@client/shared/ui-kit';

import { ControlQuestionCreateModal } from './ControlQuestionCreateModal';
import { ControlQuestionUpdateModal } from './ControlQuestionUpdateModal';
import { useCurrentQuestionQuery } from './api';
import { i18n } from './i18n';
import * as model from './model';

export const ControlQuestionListItem: VFC = () => {
  const { data, loading: isLoading } = useCurrentQuestionQuery();
  const question = data?.account.question?.text;

  const handleOnPress = useEvent(model.dialog.show);

  if (isLoading) {
    return null;
  }

  return (
    <>
      <ListItemAction
        {...logProps('listitem.control-question')}
        data-testid="kvko-list-item"
        type={question ? 'kebab' : 'add'}
        icon={<Kvko />}
        label={question && i18n('Контрольный вопрос')}
        tabIndex={0}
        text={question ?? i18n('Добавить контрольный вопрос')}
        onPress={handleOnPress}
      />
      {question ? <ControlQuestionUpdateModal /> : <ControlQuestionCreateModal />}
      <ConfirmByPasswordModal />
    </>
  );
};
