import { createEffect } from 'effector';

import {
  SetQuestionDocument,
  SetQuestionInput,
  SetQuestionMutation,
  SetQuestionMutationVariables,
  SetQuestionProblem,
} from '@client/shared/api/graphql';
import { getOrCreateClient } from '@client/shared/libs/apollo';

export {
  SetQuestionProblemKind,
  useCurrentQuestionQuery,
  useAvailableQuestionsQuery,
} from '@client/shared/api/graphql';

export type { SetQuestionProblem, SetQuestionInput } from '@client/shared/api/graphql';
export type SetQuestionResult = boolean;

export const setQuestionFx = createEffect<SetQuestionInput, boolean, SetQuestionProblem>(
  async (input) => {
    const apollo = getOrCreateClient({});

    const result = await apollo.mutate<SetQuestionMutation, SetQuestionMutationVariables>({
      mutation: SetQuestionDocument,
      variables: { input },
    });

    if (result.data?.accountSetQuestion.__typename === 'SetQuestionProblem') {
      return Promise.reject(result.data?.accountSetQuestion);
    }

    return true;
  },
);
