import { createEffect } from 'effector';

import {
  AccountAddRecoveryEmailDocument,
  AccountAddRecoveryEmailMutation,
  AccountAddRecoveryEmailMutationVariables,
  AccountConfirmRecoveryEmailByCodeDocument,
  AccountConfirmRecoveryEmailByCodeMutation,
  AccountConfirmRecoveryEmailByLinkDocument,
  AccountConfirmRecoveryEmailByLinkMutation,
  AccountRemoveRecoveryEmailDocument,
  AccountRemoveRecoveryEmailMutation,
  AddRecoveryEmailInput,
  AddRecoveryEmailProblem,
  ConfirmRecoveryEmailByCodeInput,
  ConfirmRecoveryEmailByCodeProblem,
  ConfirmRecoveryEmailByLinkInput,
  ConfirmRecoveryEmailByLinkProblem,
  EmailType,
  RemoveRecoveryEmailInput,
  RemoveRecoveryEmailProblem,
  useRecoveryEmailsQuery,
} from '@client/shared/api/graphql';
import { getOrCreateClient, useMappedQuery } from '@client/shared/libs/apollo';

export {
  AddRecoveryEmailProblemKind,
  RemoveRecoveryEmailProblemKind,
  ConfirmRecoveryEmailByCodeProblemKind,
  ConfirmRecoveryEmailByLinkProblemKind,
} from '@client/shared/api/graphql';

export type {
  AddRecoveryEmailProblem,
  RemoveRecoveryEmailProblem,
  ConfirmRecoveryEmailByCodeProblem,
} from '@client/shared/api/graphql';
export type AddRecoverEmailResult = boolean;

export const addRecoveryEmailFx = createEffect<
  AddRecoveryEmailInput,
  string,
  AddRecoveryEmailProblem
>(async (input) => {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<
    AccountAddRecoveryEmailMutation,
    AccountAddRecoveryEmailMutationVariables
  >({
    mutation: AccountAddRecoveryEmailDocument,
    variables: { input },
  });

  if (result.data?.accountAddRecoveryEmail.__typename === 'AddRecoveryEmailProblem') {
    return Promise.reject(result.data?.accountAddRecoveryEmail);
  }

  return result.data?.accountAddRecoveryEmail.trackId as string;
});

export const removeRecoveryEmailFx = createEffect<
  RemoveRecoveryEmailInput,
  boolean,
  RemoveRecoveryEmailProblem
>(async (input) => {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<AccountRemoveRecoveryEmailMutation>({
    mutation: AccountRemoveRecoveryEmailDocument,
    variables: { input },
  });

  if (result.data?.accountRemoveRecoveryEmail.__typename === 'RemoveRecoveryEmailProblem') {
    return Promise.reject(result.data?.accountRemoveRecoveryEmail);
  }

  return true;
});

export const confirmRecoveryEmailByLinkFx = createEffect<
  ConfirmRecoveryEmailByLinkInput,
  boolean,
  ConfirmRecoveryEmailByLinkProblem
>(async (input) => {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<AccountConfirmRecoveryEmailByLinkMutation>({
    mutation: AccountConfirmRecoveryEmailByLinkDocument,
    variables: { input },
  });

  if (
    result.data?.accountConfirmRecoveryEmailByLink.__typename ===
    'ConfirmRecoveryEmailByLinkProblem'
  ) {
    return Promise.reject(result.data?.accountConfirmRecoveryEmailByLink);
  }

  return true;
});

export const confirmRecoveryEmailByCodeFx = createEffect<
  ConfirmRecoveryEmailByCodeInput,
  boolean,
  ConfirmRecoveryEmailByCodeProblem
>(async (input) => {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<AccountConfirmRecoveryEmailByCodeMutation>({
    mutation: AccountConfirmRecoveryEmailByCodeDocument,
    variables: { input },
  });

  if (
    result.data?.accountConfirmRecoveryEmailByCode.__typename ===
    'ConfirmRecoveryEmailByCodeProblem'
  ) {
    return Promise.reject(result.data?.accountConfirmRecoveryEmailByCode);
  }

  return true;
});

export function useRecoveryEmails() {
  return useMappedQuery(useRecoveryEmailsQuery, (data) => {
    return data.account.emails.filter(
      (email) => email.type !== EmailType.Native && !email.isPrimary,
    );
  });
}
