import Cookies from 'js-cookie';

export function setTrackCookie(email: string, trackId: string) {
  Cookies.set('track:' + email, trackId, {
    secure: true,
    expires: 1 / 8, // 24/8=3 часа
    sameSite: 'strict',
  });
}

export function getTrackCookie(email: string) {
  return Cookies.get('track:' + email);
}
