/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { createNotifier } from '@client/shared/libs/notifications';

const notifier = createNotifier();

export const notifications = {
  tooManyRequests: notifier.error.prepend(() => {
    return 'Слишком много попыток отправки, попробуйте ещё раз позже';
  }),

  internalError: notifier.error.prepend(() => {
    return 'Что-то пошло не так, попробуйте ещё раз позже';
  }),

  incorrectKey: notifier.error.prepend(() => {
    return 'Код подтверждения не подошёл, попробуйте ещё раз';
  }),

  confirmationStart: notifier.loading.prepend(() => {
    return 'Подтверждаем почту';
  }),

  confirmedSuccessful: notifier.success.prepend(() => {
    return 'Почта подтверждена';
  }),

  addedSuccessful: notifier.success.prepend(() => {
    return 'Почта добавлена';
  }),

  removedSuccessful: notifier.success.prepend(() => {
    return 'Почта удалена';
  }),

  alreadyConfirmed: notifier.success.prepend(() => {
    return 'Этот email уже подтверждён';
  }),
};
