import { attach, createEvent, sample } from 'effector';

import { removeQueryParams } from '@client/shared/libs/router';

import * as api from '../api';
import { notifications } from '../libs/notifier';
import type { ActivationCode } from '../types';

export const activated = createEvent<ActivationCode>();

export const confirmFx = attach({
  effect: api.confirmRecoveryEmailByLinkFx,
});

confirmFx.watch(() => removeQueryParams(['action', 'code']));

confirmFx.failData.watch((payload) => {
  switch (payload.reason) {
    case api.ConfirmRecoveryEmailByLinkProblemKind.AlreadyConfirmed:
      notifications.alreadyConfirmed();
      break;
    case api.ConfirmRecoveryEmailByLinkProblemKind.IncorrectKey:
      notifications.incorrectKey();
      break;
    case api.ConfirmRecoveryEmailByLinkProblemKind.Internal:
      notifications.internalError();
      break;
  }
});

sample({
  clock: activated.map((code) => ({ code })),
  target: [confirmFx, notifications.confirmationStart],
});

sample({
  clock: confirmFx.done,
  target: notifications.confirmedSuccessful,
});
